/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.LegendaryHeroMaker;

import LegendaryCardMaker.CardMaker;
import LegendaryCardMaker.CardMakerToolbar;
import LegendaryCardMaker.Icon;
import LegendaryCardMaker.LegendaryCardMakerFrame;
import LegendaryCardMaker.LegendaryDividerMaker.HeroDividerMakerFrame;
import LegendaryCardMaker.LegendaryHeroMaker.CardRarity;
import LegendaryCardMaker.LegendaryHeroMaker.Hero;
import LegendaryCardMaker.LegendaryHeroMaker.HeroCard;
import LegendaryCardMaker.LegendaryHeroMaker.HeroCardSelector;
import LegendaryCardMaker.LegendaryHeroMaker.HeroMaker;
import LegendaryCardMaker.exporters.ExportHomeprintProgressBarDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class HeroSelectorMenu
extends JMenu
implements ActionListener {
    JMenuItem newHero = new JMenuItem("New Hero...");
    JMenuItem edit = new JMenuItem("Edit Hero...");
    JMenuItem rename = new JMenuItem("Rename Hero...");
    JMenuItem delete = new JMenuItem("Delete Hero...");
    JMenuItem editDivider = new JMenuItem("Edit Divider...");
    JMenuItem exportJPEGHomeprint = new JMenuItem("Export to JPEG for Homeprint...");
    JMenu team = new JMenu("Set Team");
    List<JMenuItem> teamItems = new ArrayList<JMenuItem>();
    public LegendaryCardMakerFrame lcmf;
    static CardMakerToolbar tb = null;

    public HeroSelectorMenu(LegendaryCardMakerFrame lcmf, CardMakerToolbar tb) {
        HeroSelectorMenu.tb = tb;
        this.lcmf = lcmf;
        this.setText("Edit");
        this.newHero.addActionListener(this);
        this.add(this.newHero);
        this.addSeparator();
        this.edit.addActionListener(this);
        this.add(this.edit);
        this.rename.addActionListener(this);
        this.add(this.rename);
        this.delete.addActionListener(this);
        this.add(this.delete);
        this.addSeparator();
        for (Icon icon : Icon.values()) {
            if (!icon.getIconType().equals((Object)Icon.ICON_TYPE.TEAM) && !icon.getIconType().equals((Object)Icon.ICON_TYPE.NONE)) continue;
            String s = String.valueOf(icon.toString().substring(0, 1).toUpperCase()) + icon.toString().substring(1).toLowerCase();
            s = s.replace("_", " ");
            JMenuItem m = new JMenuItem(s);
            m.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (HeroSelectorMenu.this.getCurrentHero() == null) {
                        return;
                    }
                    String enumValue = ((JMenuItem)e.getSource()).getText().replace(" ", "_").toUpperCase();
                    Icon icon = Icon.valueOf(enumValue);
                    for (HeroCard hc : HeroSelectorMenu.this.getCurrentHero().cards) {
                        hc.cardTeam = icon;
                        hc.changed = true;
                        hc.imageSummary = null;
                    }
                    HeroSelectorMenu.this.getCurrentHero().imageSummary = null;
                    HeroSelectorMenu.this.getCurrentHero().changed = true;
                }
            });
            this.teamItems.add(m);
            this.team.add(m);
        }
        this.add(this.team);
        this.addSeparator();
        this.editDivider.addActionListener(this);
        this.add(this.editDivider);
        this.addSeparator();
        this.exportJPEGHomeprint.addActionListener(this);
        this.add(this.exportJPEGHomeprint);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Hero h;
        String s;
        if (e.getSource().equals(this.newHero)) {
            s = JOptionPane.showInputDialog(this.lcmf, "Enter the Hero Name", "");
            if (s == null) {
                return;
            }
            if (s != null && s.isEmpty()) {
                return;
            }
            h = new Hero();
            h.name = s;
            h.changed = true;
            HeroCard hc = HeroMaker.getBlankHeroCard();
            hc.heroName = h.name;
            hc.rarity = CardRarity.COMMON;
            hc.changed = true;
            h.cards.add(hc);
            hc = HeroMaker.getBlankHeroCard();
            hc.heroName = h.name;
            hc.rarity = CardRarity.COMMON;
            hc.changed = true;
            h.cards.add(hc);
            hc = HeroMaker.getBlankHeroCard();
            hc.heroName = h.name;
            hc.rarity = CardRarity.UNCOMMON;
            hc.changed = true;
            h.cards.add(hc);
            hc = HeroMaker.getBlankHeroCard();
            hc.heroName = h.name;
            hc.rarity = CardRarity.RARE;
            hc.changed = true;
            h.cards.add(hc);
            this.lcmf.heroListModel.addElement(h);
            this.lcmf.lcm.heroes.add(h);
        }
        if (e.getSource().equals(this.rename)) {
            if (this.getCurrentHero() == null) {
                return;
            }
            s = JOptionPane.showInputDialog(this.lcmf, "Enter the Hero Name", this.getCurrentHero().name);
            if (s == null) {
                return;
            }
            if (s != null && s.isEmpty()) {
                return;
            }
            h = this.getCurrentHero();
            h.name = s;
            h.changed = true;
            for (HeroCard hc : h.cards) {
                hc.heroName = s;
                hc.changed = true;
            }
        }
        if (e.getSource().equals(this.edit)) {
            if (this.getCurrentHero() == null) {
                return;
            }
            new HeroCardSelector(this.getCurrentHero(), this.lcmf);
        }
        if (e.getSource().equals(this.delete)) {
            if (this.getCurrentHero() == null) {
                return;
            }
            int outcome = JOptionPane.showOptionDialog(this.lcmf, "Delete Hero?", "Delete Hero?", 0, 3, null, null, null);
            if (outcome == 0) {
                this.lcmf.lcm.heroes.remove(this.getCurrentHero());
                this.getHeroListModel().removeElement(this.getCurrentHero());
            }
        }
        if (e.getSource().equals(this.editDivider)) {
            if (this.getCurrentHero() == null) {
                return;
            }
            HeroDividerMakerFrame outcome = new HeroDividerMakerFrame(this.getCurrentHero(), this.lcmf.lcm.dividerHorizontal);
        }
        if (e.getSource().equals(this.exportJPEGHomeprint)) {
            if (this.getCurrentHero() == null) {
                return;
            }
            JFileChooser chooser = new JFileChooser();
            if (this.lcmf.lcm.exportFolder != null) {
                File tf = new File(this.lcmf.lcm.exportFolder);
                chooser = new JFileChooser(tf.getParent());
            }
            chooser.setFileSelectionMode(1);
            int outcome = chooser.showSaveDialog(this);
            if (outcome == 0) {
                File f = chooser.getSelectedFile();
                this.lcmf.lcm.exportFolder = f.getAbsolutePath();
                f.mkdirs();
                try {
                    ArrayList<CardMaker> cardMakers = new ArrayList<CardMaker>();
                    for (HeroCard hc : this.getCurrentHero().cards) {
                        HeroMaker hm = new HeroMaker();
                        hm.setCard(hc);
                        int count = hc.rarity.getCount();
                        if (hc.numberInDeck > 0) {
                            count = hc.numberInDeck;
                        }
                        int i = 0;
                        while (i < count) {
                            cardMakers.add(hm);
                            ++i;
                        }
                    }
                    this.lcmf.applicationProps.put("lastExportDirectory", chooser.getSelectedFile().getAbsolutePath());
                    ExportHomeprintProgressBarDialog exporter = new ExportHomeprintProgressBarDialog(this.lcmf.lcm.getCardCount(), this.lcmf.lcm, f, cardMakers);
                    exporter.createAndShowGUI();
                    this.lcmf.saveProperties();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this.lcmf, "Error! " + ex.getMessage());
                }
            }
        }
    }

    public JList getHeroList() {
        return this.lcmf.heroList;
    }

    public DefaultListModel getHeroListModel() {
        return this.lcmf.heroListModel;
    }

    public Hero getCurrentHero() {
        Hero h = null;
        if (this.lcmf.heroListModel.size() > 0 && this.lcmf.heroList.getSelectedIndex() >= 0) {
            h = (Hero)this.lcmf.heroListModel.get(this.lcmf.heroList.getSelectedIndex());
        }
        return h;
    }
}

